/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.DurationReport;
import com.ibm.hwmca.fw.report.IntermediateReport;
import com.ibm.hwmca.fw.report.ReportListener;
import com.ibm.hwmca.fw.report.StepReport;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressDetails;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressListener;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class ProgressReportListenerImpl
implements ReportListener {
    private static final String TRACE_MASKT = "XFRMPRLT";
    private static final String TRACE_MASKF = "XFRMPRLF";
    private static final String TRACE_MASKD = "XFRMPRLD";
    private ObjectId[] ids = null;
    private ObjectId[] targets = null;
    private String progressId;
    private ProgressListener progressListener;
    private Object reportLock = new Object();
    private boolean ended = false;
    private ProgressEndEvent endEvent;

    public ProgressReportListenerImpl(String progressId, ObjectId[] targets, ProgressListener progressListener) {
        if (progressId == null) {
            throw new IllegalArgumentException("null progress id specified");
        }
        if (progressListener == null) {
            throw new IllegalArgumentException("null progress listener specified");
        }
        this.progressId = progressId;
        this.progressListener = progressListener;
        if (targets != null) {
            this.ids = new ObjectId[targets.length];
            this.targets = new ObjectId[targets.length];
            int i = 0;
            while (i < this.targets.length) {
                this.targets[i] = targets[i];
                ++i;
            }
        } else {
            this.ids = new ObjectId[0];
            targets = new ObjectId[]{};
        }
        this.endEvent = new ProgressEndEvent(progressId);
        Trace.trace(TRACE_MASKT, "<> ProgressReportListenerImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeReport(CompletionReport report) {
        Trace.trace(TRACE_MASKT, "-> ProgressReportListenerImpl.completeReport()");
        int full = 0;
        ProgressData updateData = null;
        Object object = this.reportLock;
        synchronized (object) {
            if (this.ids.length > 0) {
                int i = 0;
                while (i < this.ids.length) {
                    if (report.getObjectId().equals(this.targets[i])) {
                        if (this.ids[i] == null) {
                            this.ids[i] = report.getObjectId();
                            updateData = new ProgressData();
                            updateData.setObjectId(this.targets[i]);
                        } else {
                            Trace.trace(TRACE_MASKF, "we already have a completion report for target:" + report.getObjectId());
                        }
                    }
                    if (this.ids[i] != null) {
                        ++full;
                    }
                    ++i;
                }
            } else {
                updateData = new ProgressData();
            }
            if (updateData != null) {
                updateData.setText(report.getText());
                if (report.getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                    updateData.setCompletionStatus(1);
                    if (updateData.getText() == null) {
                        updateData.setText(new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.success"));
                    }
                } else if (report.getCompletionCode().equals(CompletionReportCode.FAIL)) {
                    updateData.setCompletionStatus(3);
                    if (report.getData() instanceof LocalizableText || report.getData() instanceof ProgressDetails) {
                        updateData.setDetails(report.getData());
                        if (updateData.getText() == null) {
                            updateData.setText(new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.failed_with_details"));
                        }
                    } else if (updateData.getText() == null) {
                        updateData.setText(new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.failed"));
                    }
                } else if (report.getCompletionCode().equals(CompletionReportCode.PARTIAL_SUCCESS)) {
                    updateData.setCompletionStatus(3);
                    if (report.getData() instanceof LocalizableText || report.getData() instanceof ProgressDetails) {
                        updateData.setDetails(report.getData());
                        if (updateData.getText() == null) {
                            updateData.setText(new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.partial_success_with_details"));
                        }
                    } else if (updateData.getText() == null) {
                        updateData.setText(new LocalizableText("com/ibm/hwmca/fw/res/common", "progress.partial_success"));
                    }
                }
                this.progressListener.updateProgress(new ProgressUpdateEvent(updateData, this.progressId));
                if (full == this.ids.length) {
                    this.ended = true;
                    this.progressListener.endProgress(this.endEvent);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- ProgressReportListenerImpl.completeReport()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intermediateReport(IntermediateReport report) {
        Trace.trace(TRACE_MASKT, "-> ProgressReportListenerImpl.intermediateReport()");
        ProgressData updateData = null;
        Object object = this.reportLock;
        synchronized (object) {
            if (this.ids.length > 0) {
                int i = 0;
                while (i < this.targets.length) {
                    if (report.getObjectId().equals(this.targets[i])) {
                        updateData = new ProgressData();
                        updateData.setObjectId(this.targets[i]);
                    }
                    ++i;
                }
            } else {
                updateData = new ProgressData();
            }
            if (updateData != null) {
                if (report instanceof StepReport) {
                    updateData.setText(((StepReport)report).getText());
                } else if (report instanceof DurationReport) {
                    updateData.setDurationTime(((DurationReport)report).getDuration());
                }
                this.progressListener.updateProgress(new ProgressUpdateEvent(updateData, this.progressId));
            }
        }
        Trace.trace(TRACE_MASKT, "<- ProgressReportListenerImpl.intermediateReport()");
    }

    public void errorReport(Throwable thrown) {
        Trace.trace(TRACE_MASKT, "-> ProgressReportListenerImpl.errorReport()");
        this.ended = true;
        this.progressListener.endProgress(this.endEvent);
        Trace.trace(TRACE_MASKT, "<- ProgressReportListenerImpl.errorReport()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(CompletionReport report) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> ProgressReportListenerImpl.finished()");
        if (report == null) {
            throw new IllegalArgumentException("report specified as null");
        }
        ArrayList<CompletionReport> noreport = new ArrayList<CompletionReport>();
        Object object = this.reportLock;
        synchronized (object) {
            if (this.ids.length > 0) {
                int i = 0;
                while (i < this.ids.length) {
                    if (this.ids[i] == null) {
                        CompletionReport rpt = (CompletionReport)report.clone();
                        rpt.setObjectId(this.targets[i]);
                        noreport.add(rpt);
                    }
                    ++i;
                }
            } else {
                CompletionReport rpt = (CompletionReport)report.clone();
                rpt.setObjectId(null);
                noreport.add(rpt);
            }
        }
        int i = 0;
        while (i < noreport.size()) {
            this.completeReport((CompletionReport)noreport.get(i));
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- ProgressReportListenerImpl.finished()");
    }

    public ProgressListener getProgressListener() {
        Trace.trace(TRACE_MASKT, "<> ProgressReportListenerImpl.getProgressListener() - " + this.progressListener);
        return this.progressListener;
    }

    public String getProgressId() {
        Trace.trace(TRACE_MASKT, "<> ProgressReportListenerImpl.getProgressId() - " + this.progressId);
        return this.progressId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(ObjectId objectId) throws IllegalStateException {
        if (this.ended) {
            throw new IllegalStateException("Cannot add targets after progress window is ended");
        }
        if (objectId != null) {
            Object object = this.reportLock;
            synchronized (object) {
                boolean found = false;
                int i = 0;
                while (i < this.targets.length && !found) {
                    if (this.targets[i] != null && this.targets[i].equals(objectId)) {
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    ObjectId[] newIds = new ObjectId[this.ids.length + 1];
                    ObjectId[] newTargets = new ObjectId[this.targets.length + 1];
                    System.arraycopy(this.ids, 0, newIds, 0, this.ids.length);
                    newIds[this.ids.length] = null;
                    System.arraycopy(this.targets, 0, newTargets, 0, this.targets.length);
                    newTargets[this.targets.length] = objectId;
                    this.targets = newTargets;
                    this.ids = newIds;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(ObjectId objectId) throws IllegalStateException {
        if (this.ended) {
            throw new IllegalStateException("Cannot remove targets after progress window is ended");
        }
        if (objectId != null) {
            Object object = this.reportLock;
            synchronized (object) {
                boolean found = false;
                ObjectId[] newIds = new ObjectId[this.ids.length - 1];
                ObjectId[] newTargets = new ObjectId[this.targets.length - 1];
                int j = 0;
                int full = 0;
                int i = 0;
                while (i < this.targets.length) {
                    if (!found && this.targets[i] != null && this.targets[i].equals(objectId)) {
                        found = true;
                    } else {
                        if (this.ids[i] != null) {
                            ++full;
                        }
                        newIds[j] = this.ids[i];
                        newTargets[j] = this.targets[i];
                        ++j;
                    }
                    ++i;
                }
                if (found) {
                    this.targets = newTargets;
                    this.ids = newIds;
                }
                if (full == this.ids.length) {
                    this.ended = true;
                    this.progressListener.endProgress(this.endEvent);
                }
            }
        }
    }

    public ProgressEndEvent getProgressEndEvent() {
        return this.endEvent;
    }

    public void setProgressEndEvent(ProgressEndEvent endEvent) {
        this.endEvent = endEvent;
        endEvent.setId(this.progressId);
    }
}

